import * as echarts from 'echarts'
import { Radar } from '@antv/g2plot'
import cq from '@/assets/js/cq.js'
import main9 from '@/assets/js/main9.js'
import dialogConfig from '@/views/BigScreen/js/DistrictReformDialogConfig.js'
import { mapState } from 'vuex'
import VueSeamlessScroll from 'vue-seamless-scroll'
import dialogComponents from '@/views/BigScreen/js/dialog_components.js'
import EasyDialog from '@/views/BigScreen/components/easy-dialog/index.vue'
import fakeData from '@/views/BigScreen/js/fakeData_district.js'
import apiList from '@/api/bigScreen/districView.js'
import bigScreenMixin from '@/mixins/bigScreenMixin.js'
import utils from '@/utils.js'
import screenHeader from '@/views/BigScreen/components/screenHeader.vue'
import dataMixin from '@/views/BigScreen/js/DistrictReformMethods.js'
import { size } from 'lodash'
export default {
    name: 'DistrictReformMixin',
    data() {
        return {
            eightIndex: [
                {
                    name: '承接国家<br/>试点项目数',
                    number: 0,
                    unit: '个',
                    comp: 'mapTarget_1'
                },
                {
                    name: '承接市级<br/>试点项目数',
                    number: 0,
                    unit: '个',
                    comp: 'mapTarget_2'
                },
                {
                    name: '承接的国家和市级<br/>试点按时通过验收率',
                    number: 0,
                    unit: '%',
                    comp: 'mapTarget_3'
                },
                {
                    name: '本年度新增国家<br/>和市级试点项目数',
                    number: 0,
                    unit: '个',
                    comp: 'mapTarget_4'
                },
                {
                    name: '改革经验<br/>获全国性肯定评价',
                    number: 0,
                    unit: '次',
                    comp: 'mapTarget_5'
                },
                {
                    name: '改革经验<br/>获全市推广',
                    number: 0,
                    unit: '次',
                    comp: 'mapTarget_6'
                },
                {
                    name: '改革经验被5家中央<br/>媒体深度专题报道',
                    number: 0,
                    unit: '次',
                    comp: 'mapTarget_7'
                },
                {
                    name: '社情民意<br/>电话调查满意度',
                    number: 0,
                    unit: '%',
                    comp: 'mapTarget_8'
                }
            ],
            loadingColor: 'rgba(6, 46, 106, 0.01)',
            loadObj: {
                scrollListData1: false,
                scrollListData2: false,
                brandList: false,
                pilotReform: false,
                scrollBoradData: false,
                scrollListDataBottom: false,
                loadingMap: false,
            },
            ggbb_ssly: [],
            showWorkPlat: false,
            workPlatMenu: [],
            currentTabComponent: '',
            tableOptions: null,
            dialogOption: {
                dialogTitle: '',
                width: '50%',
            },
            showEasy: false,
            mapDialogShow: false,
            mapDialogTop: 0,
            mapDialogleft: 0,
            // 地图分类颜色值
            typeColor1: '#398C8F', // 优
            typeColor2: '#1970c1', // 良
            typeColor3: '#B0825C', // 一般
            // 主城九区区域编码
            main9Code: [
                '500103000000',
                '500112000000',
                '500108000000',
                '500106000000',
                '500104000000',
                '500107000000',
                '500105000000',
                '500113000000',
                '500109000000',
            ],
            currentMenu: {
                name: '',
            },
            currentKey: 'DistrictReformView',
            menuData: [],
            activeBtn: 1,
            activeBtnKey: 'composite',
            myChartCQ: null,
            myChartMain: null,
            optionCQ: null,
            optionMain: null,
            // 单项指数排行榜
            singleheader: [
                {
                    name: '指数',
                    width: '33.33%',
                },
                {
                    name: '入榜区县',
                    width: '33.33%',
                },
                // {
                //     name: '得分',
                //     width: '25%',
                // },
                // {
                //     name: '全市排位',  //放在区县名字前面展示
                //     width: '16%',
                // },
                {
                    name: '入榜形式', // 显示 蝉联冠军  新进冠军
                    width: '33.33%',
                },
            ],
            // 指数排行榜
            scrollheader1: [
                {
                    name: '区县',
                    width: '28%',
                },
                {
                    name: '得分',
                    width: '18%',
                },
                {
                    name: '区域排位',
                    width: '18%',
                },
                {
                    name: '全市排位',
                    width: '18%',
                },
                {
                    name: '区域变化',
                    width: '18%',
                },
            ],
            scrollListData1: [],
            // 一地创新
            scrollheader2: [
                {
                    name: '区县',
                    width: '25%',
                },
                {
                    name: '获推广典型经验(条)',
                    width: '40%',
                },
                {
                    name: '排位',
                    width: '20%',
                },
                {
                    name: '变化',
                    width: '20%',
                },
            ],
            scrollListData2: [],
            // 改革品牌
            scrollheader3: [
                {
                    name: '区县',
                    width: '20%',
                },
                {
                    name: '获全国肯定性<br>评价(次)',
                    width: '32%',
                    type: 'l',
                },
                {
                    name: '获中央媒体深度<br>专题报道(次)',
                    width: '33%',
                    type: 'l',
                },
                {
                    name: '排位',
                    width: '15%',
                },
            ],
            scrollListData3: [],
            // 地图滚动数据
            scrollBoradData: [
                //     {
                //         id: 1,
                //         name: '江津举办xx现场会',
                //     },
                //     {
                //         id: 2,
                //         name: '江津区陆海新通道打通xx一公里',
                //     },
                //     {
                //         id: 3,
                //         name: '沙坪坝区陆海新通道打通xx一公里',
                //     },
                //     {
                //         id: 4,
                //         name: '北碚区陆海新通道打通xx一公里',
                //     },
                //     {
                //         id: 5,
                //         name: '南岸区陆海新通道打通xx一公里',
                //     },
                //     {
                //         id: 6,
                //         name: '江津区陆海新通道打通xx一公里',
                //     },
                //     {
                //         id: 7,
                //         name: '北碚区陆海新通道打通xx一公里',
                //     },
            ],
            // 指数排行榜
            scrollheaderBottom: [
                {
                    name: '区县',
                    width: '20%',
                },
                {
                    name: '提出需求',
                    width: '18%',
                },
                {
                    name: '转化为清单',
                    width: '24%',
                },
                {
                    name: '质效指数',
                    width: '18%',
                },
                {
                    name: '排名',
                    width: '20%',
                },
            ],
            scrollListDataBottom: [],
            reformBrandData: [
                { time: '1月', value: 4, count: 1 },
                { time: '2月', value: 5, count: 2 },
                { time: '3月', value: 2, count: 4 },
                { time: '4月', value: 1, count: 3 },
                { time: '5月', value: 2, count: 1 },
                { time: '6月', value: 4, count: 4 },
            ],
            reformBrandOption: null,
            reformBrandChart: null,
            reformData: null,
            // 雷达 总书记指示
            rayChart: null,
            rayChartOption: null,
            // 对接时 max设置为值的1.2倍
            rayChartData: [
                {
                    name: '经济和社会民生',
                    value: 60,
                    type: '习近平总书记重要指示批示、重要讲话精神',
                },
                { name: '经济和社会民生', value: 70, type: '群众企业基层所盼' },
                { name: '经济和社会民生', value: 80, type: '其他省市先进经验' },

                {
                    name: '文化',
                    value: 80,
                    type: '习近平总书记重要指示批示、重要讲话精神',
                },
                { name: '文化', value: 70, type: '群众企业基层所盼' },
                { name: '文化', value: 60, type: '其他省市先进经验' },

                {
                    name: '平安法治',
                    value: 40,
                    type: '习近平总书记重要指示批示、重要讲话精神',
                },
                { name: '平安法治', value: 50, type: '群众企业基层所盼' },
                { name: '平安法治', value: 20, type: '其他省市先进经验' },

                {
                    name: '民主法制',
                    value: 70,
                    type: '习近平总书记重要指示批示、重要讲话精神',
                },
                { name: '民主法制', value: 40, type: '群众企业基层所盼' },
                { name: '民主法制', value: 10, type: '其他省市先进经验' },

                {
                    name: '党建统领',
                    value: 60,
                    type: '习近平总书记重要指示批示、重要讲话精神',
                },
                { name: '党建统领', value: 50, type: '群众企业基层所盼' },
                { name: '党建统领', value: 30, type: '其他省市先进经验' },
            ],
            // 雷达 所属领域
            rayChart2: null,
            rayChartOption2: null,
            // 对接时 max设置为值的1.2倍
            rayChartData2: [
                { name: '经济和社会民生', value: 20, type: '国家级' },
                { name: '经济和社会民生', value: 120, type: '市级' },

                { name: '文化', value: 20, type: '国家级' },
                { name: '文化', value: 80, type: '市级' },

                { name: '平安法治', value: 18, type: '国家级' },
                { name: '平安法治', value: 78, type: '市级' },

                { name: '民主法制', value: 5, type: '国家级' },
                { name: '民主法制', value: 115, type: '市级' },

                { name: '党建统领', value: 10, type: '国家级' },
                { name: '党建统领', value: 70, type: '市级' },
            ],
            // 部署时间
            deployTimeChart: null,
            deployTimeOption: null,
            deployTimeData: [],
            // 盼望
            hopeChart: null,
            hopeOption: null,
            hopeData: [],
            // 需求来源
            quarterData: [
                {
                    value: 1,
                    name: '一季度',
                },
                { value: 2, name: '二季度' },
                { value: 3, name: '三季度' },
                { value: 4, name: '四季度' },
            ],
            ggbb_lyqd: [],
            heatBarChart: null,
            heatBarOption: null,
            legendBottom: [],
            legendTop: [],
            heatBarData: [],
            //品牌榜chart数据
            brandChartData1: [],
            brandChartData2: [],
            //改革试点成果
            // 形成制度成果
            achievement1: {
                totalAchievement: 0,
                gapQAchievement: 0,
            },
            // 搭建工作平台
            achievement2: {
                totalAchievement: 0,
                gapQAchievement: 0,
            },
            // 上线应用场景
            achievement3: {
                totalAchievement: 0,
                gapQAchievement: 0,
            },
            // 部署时间
            deploymentTimeData: {},
            deploymentTimeYear: [],
            deploymentTimeData1: [],
            deploymentTimeData2: [],
            // 指数 单项
            indexSingleData: [],
            // 地图数据
            compositeMapData: [],
            workableMapData: [],
            brandMapData: [],
            satisfactionMapData: [],
            riskMapData: [],
            fxcd: [], //事件风险程度
            quarter: null,
            year: null,
            currentQuarter: null
        }
    },
    computed: {
        ...mapState({
            frontMenus: (state) => {
                return state.menu.frontMenus
            },
        }),
        optionSingleHeightTime() {
            return {
                step: 0.1,
            }
        },
    },
    created() {
        this.ggbb_ssly = utils.getDictItemsFromCache('ggbb_ssly')
        this.ggbb_lyqd = utils.getDictItemsFromCache('ggbb_lyqd')
        this.fxcd = utils.getDictItemsFromCache('fxcd')
    },
    mounted() {
        this.nowQuarter()
        let searchDate = sessionStorage.getItem('searchDate')
        if (searchDate) {
            searchDate = JSON.parse(searchDate)
            this.year = searchDate.year
            this.quarter = searchDate.quarter
        } else {
            this.checkQuarter()
        }
        this.$nextTick(() => {
            this.initMapMain()
            this.initMapCQ()
            this.loadData('init')
        })
        this.$bus.$on('changeDate', (searchDate) => {
            this.quarter = searchDate.quarter
            this.year = searchDate.year
            if (this.$route.path == '/DistrictReformView') {
                this.loadData()
            }
        })
        this.$root.$on('resize', () => {
            this.resize(500)
        })
    },
    beforeDestory() {
        this.$bus.$off('changeDate')
        let tooltip = document.querySelectorAll('.data-tooltip')
        Array.from(tooltip).forEach((item) => {
            item.remove()
        })
    },
    methods: {
        handleDetail(comp, type) {
            this.$router.push({
                path: '/DetailComponent',
                name: 'DetailComponent',
                query: {
                    comp,
                    type
                }
            })
        },
        getFileData(type) {
            if (type == 'satisfaction') {
                let data = this.qs.stringify({
                    year: this.year,
                    quarter: this.quarter,
                })
                apiList.satisfactionFile(data, (res) => {
                    if (res.satisfaction && res.satisfaction.id) {
                        this.openSubDialog('satisfactionReport', {
                            fileId: res.satisfaction.id
                        })
                    } else {
                        this.openSubDialog('satisfactionReport')
                    }
                })
            }
        },
        nowQuarter() {
            let month = new Date().getMonth() + 1
            if (month <= 3) {
                this.currentQuarter = 1
            } else if (month <= 6) {
                this.currentQuarter = 2
            } else if (month <= 9) {
                this.currentQuarter = 3
            } else if (month <= 12) {
                this.currentQuarter = 4
            }
        },
        checkQuarter() {
            this.year = new Date().getFullYear()
            let month = new Date().getMonth() + 1
            if (month <= 3) {
                this.quarter = 1
            } else if (month <= 6) {
                this.quarter = 2
            } else if (month <= 9) {
                this.quarter = 3
            } else if (month <= 12) {
                this.quarter = 4
            }
        },
        goToSub(type) {
            let data = {
                ljxq: {
                    name: '两江新区',
                    code: '500191000000',
                },
                gxq: {
                    name: '高新区',
                    code: '500193000000',
                },
            }
            this.$router.push({
                path: '/DistrictReformSubView',
                query: {
                    name: data[type].name,
                    code: data[type].code,
                },
            })
            let tooltip = document.getElementsByClassName('data-tooltip')
            Array.from(tooltip).forEach((item) => {
                item.remove()
            })
        },
        convertScatter(data, mapData, showTitle, key) {
            let res = []
            let tooltip
            for (let i = 0; i < data.length; i++) {
                let obj = data[i].properties
                let color = '#081c47'
                let find = mapData.find((item) => item.unitCode == obj.code)
                if (find) {
                    let center = obj.center ? obj.center : obj.centroid
                    res.push([center[0], center[1], obj.name, find.eventData])
                }
                tooltip = {
                    className: 'data-tooltip',
                    show: true,
                    appendToBody: true,
                    backgroundColor: 'rgba(6, 47, 107, 1)',
                    borderColor: 'rgba(2, 115, 233, 1)',
                    textStyle: {
                        color: '#fff',
                    },
                    confine: true,
                    formatter: (data) => {
                        let eventData = []
                        if (data && data.value[3]) {
                            eventData = data.value[3]
                        }
                        let strE = ''
                        eventData.forEach((item) => {
                            let fxcd = this.getDictName('fxcd', item.riskLevel)
                            let ggfx_ywlb = this.getDictName(
                                'ggfx_ywlb',
                                item.riskType
                            )
                            strE += `<div class='tooltip-item'> ${ggfx_ywlb} [${fxcd}]：<em>${item.riskName}</em></div>`
                        })
                        let str = `<div class="custom-tooltip">
                                <div class='tooltip-title'>${data.value[2]}</div>
                                ${strE}
                            </div>`
                        return str
                    },
                }
            }
            return { res, tooltip }
        },
        convertData(data, mapData, key, showTitle) {
            let res = []
            for (let i = 0; i < data.length; i++) {
                let obj = data[i].properties
                let color = '#081c47'
                let find = mapData.find((item) => item.unitCode == obj.code)

                let regionSnKey = 'allSn'
                if (key == 'workable') {
                    regionSnKey = 'workableAllSn'
                }
                if (key == 'brand') {
                    regionSnKey = 'brandAllSn'
                }
                if (key == 'satisfaction') {
                    regionSnKey = 'satisfiedAllSn'
                }
                if (find && key !== 'risk') {
                    if (find[regionSnKey] <= 5) {
                        color = '#398C8F'
                    } else if (find[regionSnKey] <= 13) {
                        color = '#1970C1'
                    } else if (find[regionSnKey] <= 28) {
                        color = '#A3A355'
                    } else if (find[regionSnKey] <= 36) {
                        color = '#B0825C'
                    } else if (find[regionSnKey] <= 41) {
                        color = '#9B4E55'
                    }
                }
                let show = true
                let offset = [0, 0]
                if (
                    [
                        '渝中区',
                        '大渡口区',
                        '江北区',
                        '沙坪坝区',
                        '九龙坡区',
                        '南岸区',
                        '北碚区',
                        '渝北区',
                        '巴南区',
                        '两江新区',
                        '高新区',
                    ].includes(obj.name)
                ) {
                    show = false
                }
                if (['沙坪坝区'].includes(obj.name)) {
                    offset = [-10, 0]
                }
                if (['九龙坡区'].includes(obj.name)) {
                    offset = [-10, -10]
                }
                if (['大渡口区'].includes(obj.name)) {
                    offset = [0, 5]
                }
                if (['江北区'].includes(obj.name)) {
                    offset = [10, 0]
                }
                if (['南岸区'].includes(obj.name)) {
                    offset = [10, 6]
                }
                if (['綦江区'].includes(obj.name)) {
                    offset = [0, 20]
                }
                if (showTitle != undefined) {
                    show = showTitle
                }
                if (obj.name == '两江新区' || obj.name == '高新区') {
                    show = false
                }
                res.push({
                    name: obj.name,
                    value: find ? find['unitCode'] : 0,
                    itemStyle: {
                        color: color,
                        areaColor: color,
                        label: {
                            show,
                        },
                    },
                    label: {
                        normal: {
                            show,
                            offset, //是否对文字进行偏移。默认不偏移。例如：[30, 40] 表示文字在横向上偏移 30，纵向上偏移 40。
                            position: 'inside', //标签的位置。// 绝对的像素值[10, 10]
                            color: '#fff',
                            fontSize: 12,
                        },
                    },
                    emphasis: {
                        disabled: true,
                    },
                    tooltip: {
                        className: 'data-tooltip',
                        show: key == 'risk' ? false : true,
                        appendToBody: true,
                        backgroundColor: 'rgba(6, 47, 107, 1)',
                        borderColor: 'rgba(2, 115, 233, 1)',
                        textStyle: {
                            color: '#fff',
                        },
                        confine: true,
                        formatter: (data) => {
                            let str = this.formatter(find, obj, key)
                            return str
                        },
                    },
                })
            }
            return res
        },
        // convertData(data, mapData, key, showTitle) {
        //     let res = []
        //     for (let i = 0; i < data.length; i++) {
        //         let obj = data[i].properties
        //         let color = '#081c47'
        //         let find = mapData.find((item) => item.unitCode == obj.code)

        //         let regionSnKey = 'regionSn'
        //         if (key == 'workable') {
        //             regionSnKey = 'workableRegionSn'
        //         }
        //         if (key == 'brand') {
        //             regionSnKey = 'brandRegionSn'
        //         }
        //         if (key == 'satisfaction') {
        //             regionSnKey = 'satisfiedRegionSn'
        //         }
        //         if (find && key !== 'risk') {
        //             if (
        //                 (find['unitGrade'] == 2 && find[regionSnKey] <= 4) ||
        //                 (find['unitGrade'] == 3 && find[regionSnKey] <= 2) ||
        //                 (find['unitGrade'] == 4 && find[regionSnKey] <= 1)
        //             ) {
        //                 color = '#398C8F'
        //             } else if (
        //                 (find['unitGrade'] == 2 &&
        //                     find[regionSnKey] >= 5 &&
        //                     find[regionSnKey] <= 12) ||
        //                 (find['unitGrade'] == 3 &&
        //                     find[regionSnKey] >= 3 &&
        //                     find[regionSnKey] <= 6) ||
        //                 (find['unitGrade'] == 4 &&
        //                     find[regionSnKey] >= 2 &&
        //                     find[regionSnKey] <= 3)
        //             ) {
        //                 color = '#1970C1'
        //             } else if (
        //                 (find['unitGrade'] == 2 &&
        //                     find[regionSnKey] >= 13 &&
        //                     find[regionSnKey] <= 20) ||
        //                 (find['unitGrade'] == 3 &&
        //                     find[regionSnKey] >= 7 &&
        //                     find[regionSnKey] <= 10) ||
        //                 (find['unitGrade'] == 4 &&
        //                     find[regionSnKey] >= 4 &&
        //                     find[regionSnKey] <= 5)
        //             ) {
        //                 color = '#B0825C'
        //             } else if (
        //                 (find['unitGrade'] == 2 &&
        //                     find[regionSnKey] >= 21 &&
        //                     find[regionSnKey] <= 24) ||
        //                 (find['unitGrade'] == 3 && find[regionSnKey] == 11) ||
        //                 (find['unitGrade'] == 4 && find[regionSnKey] == 6)
        //             ) {
        //                 color = '#9B4E55'
        //             }
        //             //  else if (find['type'] == 5) {
        //             // color = '#A3A355'
        //             //     color = '#9B4E55'
        //             // }
        //         }
        //         let show = true
        //         let offset = [0, 0]
        //         if (
        //             [
        //                 '渝中区',
        //                 '大渡口区',
        //                 '江北区',
        //                 '沙坪坝区',
        //                 '九龙坡区',
        //                 '南岸区',
        //                 '北碚区',
        //                 '渝北区',
        //                 '巴南区',
        //                 '两江新区',
        //                 '高新区',
        //             ].includes(obj.name)
        //         ) {
        //             show = false
        //         }
        //         if (['沙坪坝区'].includes(obj.name)) {
        //             offset = [-10, 0]
        //         }
        //         if (['九龙坡区'].includes(obj.name)) {
        //             offset = [-10, -10]
        //         }
        //         if (['大渡口区'].includes(obj.name)) {
        //             offset = [0, 5]
        //         }
        //         if (['江北区'].includes(obj.name)) {
        //             offset = [10, 0]
        //         }
        //         if (['南岸区'].includes(obj.name)) {
        //             offset = [10, 6]
        //         }
        //         if (['綦江区'].includes(obj.name)) {
        //             offset = [0, 20]
        //         }
        //         if (showTitle != undefined) {
        //             show = showTitle
        //         }
        //         if (obj.name == '两江新区' || obj.name == '高新区') {
        //             show = false
        //         }
        //         res.push({
        //             name: obj.name,
        //             value: find ? find['unitCode'] : 0,
        //             itemStyle: {
        //                 color: color,
        //                 areaColor: color,
        //                 label: {
        //                     show,
        //                 },
        //             },
        //             label: {
        //                 normal: {
        //                     show,
        //                     offset, //是否对文字进行偏移。默认不偏移。例如：[30, 40] 表示文字在横向上偏移 30，纵向上偏移 40。
        //                     position: 'inside', //标签的位置。// 绝对的像素值[10, 10]
        //                     color: '#fff',
        //                     fontSize: 10,
        //                 },
        //             },
        //             emphasis: {
        //                 disabled: true,
        //             },
        //             tooltip: {
        //                 className: 'data-tooltip',
        //                 show: key == 'risk' ? false : true,
        //                 appendToBody: true,
        //                 backgroundColor: 'rgba(6, 47, 107, 1)',
        //                 borderColor: 'rgba(2, 115, 233, 1)',
        //                 textStyle: {
        //                     color: '#fff',
        //                 },
        //                 confine: true,
        //                 formatter: (data) => {
        //                     let str = this.formatter(find, obj, key)
        //                     return str
        //                 },
        //             },
        //         })
        //     }
        //     return res
        // },
        loadData(type) {
            // type == init  初始化查询
            this.getGisData()
            this.loadNews() // 新闻动态
            this.getTarget() // 重点关注
            // this.getIndex() // 指数排行榜  √
            this.getBroad() // 一地创新 全市推广 √
            this.getBrand(type) // 品牌榜 √
            this.getPilotReform(type) // 改革试点√
            // this.getDemandHeatList(type)// 需求热力榜 √
        },
        getTarget() {
            apiList.getTarget({
                quarter: this.quarter,
                year: this.year,
            }).then(res => {
                console.log(res, "target")
                if (res.state) {
                    this.eightIndex[0].number = res.value.nationalProjectNum
                    this.eightIndex[1].number = res.value.cityProjectNum
                    this.eightIndex[2].number = res.value.passRate
                    this.eightIndex[3].number = res.value.addNum
                    this.eightIndex[4].number = res.value.nationwideNum
                    this.eightIndex[5].number = res.value.cityNum
                    this.eightIndex[6].number = res.value.mediaNum
                    this.eightIndex[7].number = res.value.satisfied
                }
            })
        },
        getIndex() {
            this.loadObj.scrollListData1 = true
            let data1 = this.qs.stringify({
                year: this.year,
                quarter: this.quarter,
                type: 'composite',
            })
            let data2 = this.qs.stringify({
                year: this.year,
                quarter: this.quarter,
                type: 'single',
            })
            // 综合
            apiList.getIndex(data1, (res) => {
                if (res && res.value) {
                    this.scrollListData1 = res.value
                }
                this.loadObj.scrollListData1 = false
            })
            // 单项
            apiList.getIndex(data2, (res) => {
                let dataTemp = res.value
                this.indexSingleData = []
                dataTemp.forEach((item) => {
                    let countys = item.county.split(',')
                    let holdNum = item.holdNum.split(',')
                    countys.forEach((county, index) => {
                        this.indexSingleData.push({
                            key: item.index,
                            county: county ? county : '暂无数据',
                            holdNum: holdNum[index],
                        })
                    })
                })
            })
        },
        getBroad() {
            this.loadObj.scrollListData2 = true
            let data = this.qs.stringify({
                type: 1,
                quarter: this.quarter,
                year: this.year,
            })
            apiList.getBroad(data, (res) => {
                if (res && res.value) {
                    this.scrollListData2 = res.value
                }
                this.loadObj.scrollListData2 = false
            })
        },
        getBrand(type) {
            this.loadObj.brandList = true
            this.brandChartData1.length = 12
            this.brandChartData2.length = 12
            let data = this.qs.stringify({
                quarter: this.quarter,
                year: this.year,
            })
            apiList.getBrand(data, (res) => {
                if (res && res.value && res.value.brand) {
                    this.scrollListData3 = res.value.brand
                }
                if (res && res.value && res.value.chart) {
                    let chartData = res.value.chart
                    chartData[1].forEach((item, i) => {
                        this.brandChartData1[i] = item.effectCount
                    })
                    chartData[3].forEach((item, i) => {
                        this.brandChartData2[i] = item.effectCount
                    })
                }
                if (type) {
                    this.initReformBrand()
                } else {
                    this.reformBrandChart.setOption(this.reformBrandOption)
                }
                this.loadObj.brandList = false
            })
        },
        getPilotReform(type) {
            this.loadObj.pilotReform = true
            let data = this.qs.stringify({
                quarter: this.quarter,
                year: this.year,
            })
            apiList.getPilotReform(data, (res) => {
                if (res && res.value && res.value.chart) {
                    this.deploymentTimeData = {}
                    this.deploymentTimeYear = []
                    this.deploymentTimeData1 = []
                    this.deploymentTimeData2 = []
                    let data = res.value.chart
                    data[1] &&
                        data[1].forEach((item) => {
                            if (!this.deploymentTimeData[item.x]) {
                                this.deploymentTimeData[item.x] = {
                                    country: item.y,
                                }
                            } else {
                                this.deploymentTimeData[item.x].country = item.y
                            }
                        })
                    data[2] &&
                        data[2].forEach((item) => {
                            if (!this.deploymentTimeData[item.x]) {
                                this.deploymentTimeData[item.x] = {
                                    city: item.y,
                                }
                            } else {
                                this.deploymentTimeData[item.x].city = item.y
                            }
                        })
                    for (let year in this.deploymentTimeData) {
                        this.deploymentTimeYear.push(year)
                        let city =
                            this.deploymentTimeData[year].city || undefined
                        let country =
                            this.deploymentTimeData[year].country || undefined
                        this.deploymentTimeData1.push(city)
                        this.deploymentTimeData2.push(country)
                    }
                    console.log(this.deploymentTimeData1)

                    if (type) {
                        this.initLineChart()
                    } else {
                        this.deployTimeOption.xAxis.data = this.deploymentTimeYear
                        this.deployTimeOption.series[0].data = this.deploymentTimeData1
                        this.deployTimeOption.series[1].data = this.deploymentTimeData2
                        this.deployTimeChart.setOption(this.deployTimeOption)
                    }

                }
                if (res && res.value && res.value.achievement) {
                    res.value.achievement.forEach((item) => {
                        if (item.achievementType == 1) {
                            this.achievement1.totalAchievement =
                                item.totalAchievement || 0
                            this.achievement1.gapQAchievement =
                                item.gapQAchievement || 0
                        }
                        if (item.achievementType == 2) {
                            this.achievement2.totalAchievement =
                                item.totalAchievement || 0
                            this.achievement2.gapQAchievement =
                                item.gapQAchievement || 0
                        }
                        if (item.achievementType == 3) {
                            this.achievement3.totalAchievement =
                                item.totalAchievement || 0
                            this.achievement3.gapQAchievement =
                                item.gapQAchievement || 0
                        }
                    })
                }
                this.loadObj.pilotReform = false
            })
        },
        getGisData() {
            this.loadObj.loadingMap = true
            // composite 综合评价指数、workable 改革落实力、brand 品牌显示度、satisfaction 改革满意度、risk 风险管控力
            let types = [
                'composite',
                'workable',
                'brand',
                'satisfaction',
                'risk',
            ]
            types.forEach((type) => {
                let data = this.qs.stringify({
                    type,
                    quarter: this.quarter,
                    year: this.year,
                })
                apiList.getGisData(data, (res) => {
                    this[`${type}MapData`] = this.formatMapData(type, res)
                })
            })
        },
        formatMapData(type, res) {
            if (type == this.activeBtnKey) {
                this.handleMapArea(res, this.activeBtnKey)
                this.loadObj.loadingMap = false
            }
            if (type == 'risk') {
                let codeArr = []
                let temp = []
                res.forEach((item) => {
                    if (!codeArr.includes(item.unitCode)) {
                        codeArr.push(item.unitCode)
                        temp.push({
                            unitCode: item.unitCode,
                            eventData: [
                                {
                                    riskName: item.riskName,
                                    riskLevel: item.riskLevel,
                                    riskType: item.riskType,
                                },
                            ],
                        })
                    } else {
                        let i = codeArr.findIndex((key) => key == item.unitCode)
                        temp[i].eventData.push({
                            riskName: item.riskName,
                            riskLevel: item.riskLevel,
                            riskType: item.riskType,
                        })
                    }
                })
                return temp
            } else {
                return res
            }
        },
        getDemandHeatList(type) {
            this.loadObj.scrollListDataBottom = true
            let data = this.qs.stringify({
                quarter: this.quarter,
                year: this.year,
            })
            // 综合
            apiList.getDemandHeatList(data, (res) => {
                if (res.chart) {
                    let chartData = res.chart
                    let heatBarData = [],
                        lyqd = {}
                    if (this.quarter == 1) {
                        heatBarData[0] = ['需求来源', '1月', '2月', '3月']
                    } else if (this.quarter == 2) {
                        heatBarData[0] = ['需求来源', '4月', '5月', '6月']
                    } else if (this.quarter == 3) {
                        heatBarData[0] = ['需求来源', '7月', '8月', '9月']
                    } else if (this.quarter == 4) {
                        heatBarData[0] = ['需求来源', '10月', '11月', '12月']
                    }
                    this.legendTop = []
                    this.legendBottom = []
                    this.ggbb_lyqd = utils.getDictItemsFromCache('ggbb_lyqd')
                    this.ggbb_lyqd.forEach((qd, i) => {
                        lyqd[qd.value] = [
                            qd.name,
                            undefined,
                            undefined,
                            undefined,
                        ]
                        if (i + 1 <= this.ggbb_lyqd.length / 2) {
                            this.legendTop.push({
                                name: qd.name,
                            })
                        } else {
                            this.legendBottom.push({
                                name: qd.name,
                            })
                        }
                    })
                    chartData.forEach((item) => {
                        let index = 1
                        if ([1, 4, 7, 10].includes(item.x)) {
                            index = 1
                        } else if ([2, 5, 8, 11].includes(item.x)) {
                            index = 2
                        } else if ([3, 6, 9, 12].includes(item.x)) {
                            index = 3
                        }
                        lyqd[item.legend][index] = item.y
                    })

                    for (let qdValue in lyqd) {
                        heatBarData.push(lyqd[qdValue])
                    }

                    this.heatBarData = heatBarData
                    if (type) {
                        this.initBarChart()
                    } else {
                        this.heatBarOption.dataset.source = this.heatBarData
                        this.heatBarOption.legend[0].data = this.legendTop
                        this.heatBarOption.legend[1].data = this.legendBottom
                        this.heatBarChart.setOption(this.heatBarOption)
                    }
                }

                this.scrollListDataBottom = res.demandRank || []
                this.loadObj.scrollListDataBottom = false
            })
        },
        initBarChart() {
            const chartDom = document.getElementById('heat-bar-chart')
            this.heatBarChart = echarts.init(chartDom)
            this.heatBarOption = {
                dataset: {
                    source: this.heatBarData,
                },
                grid: {
                    //图表离外层盒子的距离
                    top: '32%',
                    bottom: '2%',
                    left: '1%',
                    right: '2%',
                    containLabel: true,
                },
                xAxis: {
                    type: 'category',
                    boundaryGap: true,
                    axisTick: false,
                    axisLine: {
                        lineStyle: {
                            color: 'rgba(154,199,220, 0.2)',
                        },
                    },
                    axisLabel: {
                        color: '#D7F1FF',
                    },
                },
                yAxis: {
                    type: 'value',
                    // min: 0,
                    // splitNumber: 5,
                    // interval: 1,
                    axisLabel: {
                        color: '#D7F1FF',
                        formatter: (val) => {
                            if ((val >= 1 && parseInt(val, 10) === val) || val == 0) {
                                return val
                            } else {
                                return
                            }
                        }
                    },
                    axisLine: {
                        lineStyle: {
                            color: 'rgba(154,199,220, 0.2)',
                        },
                    },
                    splitLine: {
                        lineStyle: {
                            color: 'rgba(154,199,220, 0.2)',
                        },
                    },
                },
                tooltip: {
                    trigger: 'axis',
                    backgroundColor: 'rgba(6, 47, 107, 1)',
                    borderColor: 'rgba(2, 115, 233, 1)',
                    textStyle: {
                        color: '#fff',
                    },
                },
                legend: [
                    {
                        left: 'center',
                        data: this.legendTop,
                        inactiveColor: '#333333',
                        borderRadius: 6,
                        itemWidth: 14,
                        itemHeight: 6,
                        itemGap: 40,
                        textStyle: {
                            color: '#B1E3FF',
                        },
                    },
                    {
                        left: 'center',
                        top: '14%',
                        data: this.legendBottom,
                        inactiveColor: '#333333',
                        borderRadius: 6,
                        itemWidth: 14,
                        itemHeight: 6,
                        itemGap: 40,
                        textStyle: {
                            color: '#B1E3FF',
                        },
                    },
                ],
                color: ['#59C06C', '#F5B351', '#2E84D0', '#FF97AE'],
                series: [
                    {
                        type: 'bar',
                        seriesLayoutBy: 'row',
                        barWidth: 8,
                        barGap: '80%',
                        itemStyle: {
                            borderRadius: 5,
                            color: new echarts.graphic.LinearGradient(
                                0,
                                0,
                                0,
                                1,
                                [
                                    { offset: 0, color: '#59C06C' },
                                    { offset: 1, color: 'rgba(89,192,108,0.3)' },
                                ]
                            ),
                        },
                    },
                    {
                        type: 'bar',
                        seriesLayoutBy: 'row',
                        barWidth: 8,
                        barGap: '80%',
                        itemStyle: {
                            borderRadius: 5,
                            color: new echarts.graphic.LinearGradient(
                                0,
                                0,
                                0,
                                1,
                                [
                                    { offset: 0, color: '#386A97' },
                                    { offset: 1, color: 'rgba(56,106,151,0.3)' },
                                ]
                            ),
                        },
                    },
                    {
                        type: 'bar',
                        seriesLayoutBy: 'row',
                        barWidth: 8,
                        barGap: '80%',
                        itemStyle: {
                            borderRadius: 5,
                            color: new echarts.graphic.LinearGradient(
                                0,
                                0,
                                0,
                                1,
                                [
                                    { offset: 0, color: '#F8B551' },
                                    { offset: 1, color: 'rgba(248,181,81,0.3)' },
                                ]
                            ),
                        },
                    },
                    {
                        type: 'bar',
                        seriesLayoutBy: 'row',
                        barWidth: 8,
                        barGap: '80%',
                        itemStyle: {
                            borderRadius: 5,
                            color: new echarts.graphic.LinearGradient(
                                0,
                                0,
                                0,
                                1,
                                [
                                    { offset: 0, color: '#FFBBC9' },
                                    { offset: 1, color: 'rgba(255,187,201,0.3)' },
                                ]
                            ),
                        },
                    },
                ],
            }
            this.heatBarOption &&
                this.heatBarChart.setOption(this.heatBarOption)
            window.addEventListener('resize', () => this.heatBarChart.resize())
        },
        getDictName(code, value) {
            return utils.getDictName(code, value)
        },
        loadNews() {
            this.loadObj.scrollBoradData = true
            let data = {
                pageBean: { pageSize: -1, page: 1 },
                querys: [
                    {
                        group: 'main',
                        operation: 'EQUAL',
                        parentGroup: '',
                        property: 'n.EXCELLENT_',
                        relation: 'AND',
                        value: '1',
                    },
                ],
            }
            apiList.getNews(data, (res) => {
                this.scrollBoradData = res.rows
                this.loadObj.scrollBoradData = false
            })
        },
        getNewsDetail(type, row) {
            this.currentTabComponent = dialogConfig.dialogOption[type]
                .componentName
                ? dialogConfig.dialogOption[type].componentName
                : type // 动态组件名称
            if (row) {
                dialogConfig.dialogOption[type].option.dialogTitle =
                    row.title
            }
            this.tableOptions = {
                ...dialogConfig.dialogOption[type].dataOptions,
                id: row.id,
            } //table的查询参数
            this.dialogOption = dialogConfig.dialogOption[type].option //弹窗配置参数
            this.showEasy = true
        },
        openSubDialog(type, dataOptions) {
            this.currentTabComponent = dialogConfig.dialogOption[type]
                .componentName
                ? dialogConfig.dialogOption[type].componentName
                : type // 动态组件名称
            if (dataOptions) {
                this.tableOptions = {
                    ...dialogConfig.dialogOption[type].dataOptions,
                    ...dataOptions
                }
            } else {
                this.tableOptions = dialogConfig.dialogOption[type].dataOptions //table的查询参数
            }
            this.dialogOption = dialogConfig.dialogOption[type].option //弹窗配置参数
            this.showEasy = true
        },
        initLineChart() {
            const chartDom = document.getElementById('deploymentTime')
            this.deployTimeChart = echarts.init(chartDom)
            this.deployTimeOption = {
                grid: {
                    //图表离外层盒子的距离
                    top: '20%',
                    bottom: '6%',
                    left: 0,
                    right: '6%',
                    containLabel: true,
                },
                tooltip: {
                    trigger: 'axis',
                    backgroundColor: 'rgba(6, 47, 107, 1)',
                    borderColor: 'rgba(2, 115, 233, 1)',
                    textStyle: {
                        color: '#fff',
                    },
                },
                legend: {
                    data: ['市级', '国家级'],
                    inactiveColor: '#333333',
                    itemWidth: 20,
                    itemHeight: 6,
                    textStyle: {
                        color: '#B1E3FF',
                    },
                },
                xAxis: {
                    type: 'category',
                    boundaryGap: false,
                    axisTick: false,
                    axisLine: {
                        lineStyle: {
                            color: 'rgba(154,199,220, 0.2)',
                        },
                    },
                    axisLabel: {
                        color: '#D7F1FF',
                    },
                    data: this.deploymentTimeYear,
                },
                yAxis: {
                    type: 'value',
                    min: 0,
                    splitNumber: 5,
                    axisLabel: {
                        color: '#D7F1FF',
                        formatter: (val) => {
                            if ((val >= 1 && parseInt(val, 10) === val) || val == 0) {
                                return val
                            } else {
                                return
                            }
                        }
                    },
                    axisLine: {
                        lineStyle: {
                            color: 'rgba(154,199,220, 0.2)',
                        },
                    },
                    splitLine: {
                        lineStyle: {
                            color: 'rgba(154,199,220, 0.2)',
                        },
                    },
                },
                color: ['#00FFFF', '#CE01E0'],
                series: [
                    {
                        name: '市级',
                        data: this.deploymentTimeData1,
                        type: 'line',
                        symbol: 'emptyCircle',
                        symbolSize: 4,
                        areaStyle: {
                            color: {
                                type: 'linear',
                                x: 0,
                                y: 0,
                                x2: 0,
                                y2: 1,
                                colorStops: [
                                    {
                                        offset: 0,
                                        color: 'rgba(0,255,255,1)', // 0% 处的颜色
                                    },
                                    {
                                        offset: 0.4,
                                        color: 'rgba(0,255,255, 0.2)', // 0% 处的颜色
                                    },
                                    {
                                        offset: 1,
                                        color: 'rgba(0,255,255,0)', // 100% 处的颜色
                                    },
                                ],
                                global: false, // 缺省为 false
                            },
                        },
                    },
                    {
                        name: '国家级',
                        data: this.deploymentTimeData2,
                        type: 'line',
                        symbol: 'emptyCircle',
                        symbolSize: 4,
                        areaStyle: {
                            color: {
                                type: 'linear',
                                x: 0,
                                y: 0,
                                x2: 0,
                                y2: 1,
                                colorStops: [
                                    {
                                        offset: 0,
                                        color: 'rgba(206, 1, 224, 1)', // 0% 处的颜色
                                    },
                                    {
                                        offset: 0.4,
                                        color: 'rgba(206, 1, 224, 0.2)', // 0% 处的颜色
                                    },
                                    {
                                        offset: 1,
                                        color: 'rgba(206, 1, 224, 0)', // 100% 处的颜色
                                    },
                                ],
                                global: false, // 缺省为 false
                            },
                        },
                    },
                ],
            }
            this.deployTimeOption &&
                this.deployTimeChart.setOption(this.deployTimeOption)
        },
        initReformBrand() {
            const chartDom = document.getElementById('reform-brand')
            this.reformBrandChart = echarts.init(chartDom)
            this.reformBrandOption = {
                grid: {
                    //图表离外层盒子的距离
                    top: '24%',
                    bottom: 0,
                    left: 0,
                    right: 0,
                    containLabel: true,
                },
                tooltip: {
                    trigger: 'axis',
                    backgroundColor: 'rgba(6, 47, 107, 1)',
                    borderColor: 'rgba(2, 115, 233, 1)',
                    textStyle: {
                        color: '#fff',
                    },
                },
                legend: {
                    data: ['获全国肯定性评价', '获中央媒体深度专题报道'],
                    inactiveColor: '#333333',
                    borderRadius: 6,
                    itemWidth: 20,
                    itemHeight: 6,
                    textStyle: {
                        color: '#B1E3FF',
                    },
                },
                xAxis: {
                    type: 'category',
                    boundaryGap: true,
                    axisTick: false,
                    axisLine: {
                        lineStyle: {
                            color: 'rgba(154,199,220, 0.2)',
                        },
                    },
                    axisLabel: {
                        color: '#D7F1FF',
                    },
                    data: [
                        '1月',
                        '2月',
                        '3月',
                        '4月',
                        '5月',
                        '6月',
                        '7月',
                        '8月',
                        '9月',
                        '10月',
                        '11月',
                        '12月',
                    ],
                },
                yAxis: {
                    type: 'value',
                    min: 0,
                    splitNumber: 5,
                    axisLabel: {
                        color: '#D7F1FF',
                        formatter: (val) => {
                            if ((val >= 1 && parseInt(val, 10) === val) || val == 0) {
                                return val
                            } else {
                                return
                            }
                        }
                    },
                    axisLine: {
                        lineStyle: {
                            color: 'rgba(154,199,220, 0.2)',
                        },
                    },
                    splitLine: {
                        lineStyle: {
                            color: 'rgba(154,199,220, 0.2)',
                        },
                    },
                },
                color: ['#59C06C', '#FFB51F'],
                series: [
                    {
                        name: '获全国肯定性评价',
                        data: this.brandChartData1,
                        type: 'bar',
                        barWidth: 6,
                        itemStyle: {
                            borderRadius: 5,
                        },
                    },
                    {
                        name: '获中央媒体深度专题报道',
                        data: this.brandChartData2,
                        type: 'line',
                        symbol: 'emptyCircle',
                        symbolSize: 4,
                        areaStyle: {
                            color: {
                                type: 'linear',
                                x: 0,
                                y: 0,
                                x2: 0,
                                y2: 1,
                                colorStops: [
                                    {
                                        offset: 0,
                                        color: 'rgba(255, 181, 31, 1)', // 0% 处的颜色
                                    },
                                    {
                                        offset: 0.4,
                                        color: 'rgba(255, 181, 31, 0.2)', // 0% 处的颜色
                                    },
                                    {
                                        offset: 1,
                                        color: 'rgba(255, 181, 31, 0)', // 100% 处的颜色
                                    },
                                ],
                                global: false, // 缺省为 false
                            },
                        },
                    },
                ],
            }
            this.reformBrandOption &&
                this.reformBrandChart.setOption(this.reformBrandOption)
        },
        // 切换地图分类按钮
        changeMapBtn(key) {
            this.activeBtnKey = key
            if (key == 'composite') {
                this.handleMapArea(this.compositeMapData, key)
            } else if (key == 'workable') {
                this.handleMapArea(this.workableMapData, key)
            } else if (key == 'brand') {
                this.handleMapArea(this.brandMapData, key)
            } else if (key == 'satisfaction') {
                this.handleMapArea(this.satisfactionMapData, key)
            } else if (key == 'risk') {
                this.handleMapArea(this.riskMapData, key)
            }
        },
        // 按钮切换内容
        changeBtnTab(item) {
            this.activeBtn = item
        },
        formatter(area, data, key) {
            if (!area) return
            let str
            if (key == 'composite') {
                str = `<div class="custom-tooltip">
                    <div class='tooltip-title'>${data.name}</div>
                    <div class='tooltip-item'>综合评价指数：<em>${area.score || 0
                    }</em></div>
                    <div class='tooltip-item'>全市排名：<em>${area.allSn || 0
                    }</em></div>
                </div>`
            } else if (key == 'workable') {
                str = `<div class="custom-tooltip">
                    <div class='tooltip-title'>${data.name}</div>
                    <div class='tooltip-item'>承接国家级试点项目: <em>${area.nationalProjectNum || 0
                    }</em> 个</div>
                    <div class='tooltip-item'>承接国家级试点项目通过率：<em>${area.nationalPassRate || 0
                    }</em>%</div>
                    <div class='tooltip-item'>承接市级试点项目：<em>${area.cityProjectNum || 0
                    }</em> 个</div>
                    <div class='tooltip-item'>承接市级试点项目通过率：<em>${area.cityPassRate || 0
                    }</em>%</div>
                </div>`
            } else if (key == 'brand') {
                str = `<div class="custom-tooltip">
                    <div class='tooltip-title'>${data.name}</div>
                    <div class='tooltip-item'>获全国性肯定评价：<em>${area.nationwideNum || 0
                    }</em> 次</div>
                    <div class='tooltip-item'>获推广典型经验：<em>${area.cityNum || 0
                    }</em> 条</div>
                    <div class='tooltip-item'>获中央媒体深度专题报告：<em>${area.mediaNum || 0
                    }</em> 次</div>
                </div>`
            } else if (key == 'satisfaction') {
                str = `<div class="custom-tooltip">
                    <div class='tooltip-title'>${data.name}</div>
                    <div class='tooltip-item'>满意度：<em>${area.satisfied || 0
                    }</em></div>
                    <div class='tooltip-item'>满意度得分：<em>${area.satisfiedScore || 0
                    }</em></div>
                    <div class='tooltip-item'>满意度区域排名：<em>${area.satisfiedRegionSn || 0
                    }</em></div>
                    <div class='tooltip-item'>满意度全市排名：<em>${area.satisfiedAllSn || 0
                    }</em></div>
                </div>`
            } else if (key == 'risk') {
                str = `<div class="custom-tooltip">
                    <div class='tooltip-title'>${data.name}</div>
                    <div class='tooltip-item'>事件：<em>${area.eventName}</em></div>
                </div>`
            }
            return str
        },
        handleMapArea(markData, key) {
            let tooltip = {
                className: 'data-tooltip',
                show: key == 'risk' ? false : true,
                appendToBody: true,
                backgroundColor: 'rgba(6, 47, 107, 1)',
                borderColor: 'rgba(2, 115, 233, 1)',
                textStyle: {
                    color: '#fff',
                },
                confine: true,
                formatter: (data) => {
                    let str = this.formatter(find, obj, key)
                    return str
                },
            }
            if (key == 'risk') {
                let resCQ = this.convertScatter(
                    cq.features,
                    markData,
                    true,
                    key
                )
                let resMain = this.convertScatter(
                    main9.features,
                    markData,
                    true,
                    key
                )

                this.optionCQ.series[0].data = this.convertData(
                    cq.features,
                    markData,
                    key
                )

                this.optionMain.series[0].data = this.convertData(
                    cq.features,
                    markData,
                    key,
                    true
                )
                this.optionCQ.series[1].data = resCQ.res
                this.optionMain.series[1].data = resMain.res
                this.optionCQ.series[1].tooltip = resCQ.tooltip
                this.optionMain.series[1].tooltip = resMain.tooltip
                this.optionCQ.tooltip = resCQ.tooltip
                this.optionMain.tooltip = resMain.tooltip
            } else {
                this.optionCQ.series[1].data = []
                this.optionMain.series[1].data = []
                this.optionCQ.tooltip = tooltip
                this.optionMain.tooltip = tooltip
                this.optionCQ.series[0].data = this.convertData(
                    cq.features,
                    markData,
                    key
                )
                this.optionMain.series[0].data = this.convertData(
                    main9.features,
                    markData,
                    key,
                    true
                )
            }
            this.myChartCQ.setOption(this.optionCQ)
            this.myChartMain.setOption(this.optionMain)
        },
        initMapCQ() {
            let dom = document.getElementById('cq-contianer')
            let width = getComputedStyle(dom).getPropertyValue('width').replace('px', '')
            let height = getComputedStyle(dom).getPropertyValue('height').replace('px', '')
            width = parseInt(width, 10)
            height = parseInt(height, 10)
            this.myChartCQ = echarts.init(
                dom,
                null,
                {
                    renderer: 'svg',
                    width,
                    height
                }
            )
            // 注册 echarts 地图

            echarts.registerMap('cq', cq)
            var markPointData = []
            let map = 'cq',
                top = "40%",
                left = '-14%',
                zoom = 1.2,
                aspectScale = 1,
                center = [106.5049, 29], // 地图中心位置， 此处的纬度与下面的center相差1度是形成阴影的距离，可自己随意调整
                layoutCenter = ['50%', '50%']
            this.optionCQ = {
                // geo: [
                //     {
                //         map,
                //         zoom,
                //         zlevel: 0,
                //         center,
                //         aspectScale,
                //         itemStyle: {
                //             normal: {
                //                 borderWidth: 4, //设置外层边框
                //                 borderColor: 'rgba(255,225,255,0.8)',
                //                 shadowColor: 'rgba(255,225,255,0.5)',
                //                 shadowOffsetY: 6,
                //             },
                //         },
                //         emphasis: {
                //             disabled: true,
                //         },
                //         tooltip: {
                //             show: false,
                //         },
                //         top,
                //         left,
                //         layoutCenter
                //     },
                //     {
                //         map,
                //         zoom, // 地图比例
                //         zlevel: 50,
                //         center, // 地图中心位置， 此处的纬度与下面的center相差1度是形成阴影的距离，可自己随意调整
                //         aspectScale,
                //         itemStyle: {
                //             normal: {
                //                 shadowColor: '#1970C1',
                //                 shadowBlur: 10,
                //                 shadowOffsetY: 6,
                //             },
                //         },
                //         emphasis: {
                //             disabled: true,
                //         },
                //         tooltip: {
                //             show: false,
                //         },
                //         top,
                //         left,
                //         layoutCenter
                //     },
                // ],
                series: [
                    {
                        name: '重庆',
                        type: 'map', //配置显示方式为用户自定义
                        map,
                        zoom, // 地图比例
                        zlevel: 100,
                        center, // 地图中心位置， 此处的纬度与下面的center相差1度是形成阴影的距离，可自己随意调整
                        aspectScale,
                        roam: true,
                        scaleLimit: {
                            min: 0.6,
                            max: 4
                        },
                        itemStyle: {
                            normal: {
                                borderWidth: 1, //设置外层边框
                                borderColor: '#2ddcfd',
                            },
                        },
                        emphasis: {
                            disabled: true,
                        },
                        top,
                        left,
                        data: this.convertData(
                            cq.features,
                            fakeData.btnkey1,
                            'risk'
                        ),
                    },
                    {
                        type: 'scatter',
                        symbol: (value, params) => {
                            return (
                                'image://' +
                                require(`@/assets/img/bigScreen/point1.png`)
                            )
                        },
                        coordinateSystem: 'geo',
                        symbolSize: [24, 24],
                        animation: true,
                        data: markPointData,
                        zlevel: 2000,
                        itemStyle: {
                            opacity: 1,
                        },
                    },
                ],
            }
            this.myChartCQ.setOption(this.optionCQ)
            this.myChartCQ.on('click', (params) => {
                let code = params.value
                if (!code) {
                    code = this.getAreaCode(params.name, cq)
                }
                this.$router.push({
                    path: '/DistrictReformSubView',
                    query: {
                        name: params.name,
                        code: code,
                    },
                })
                let tooltip = document.getElementsByClassName('data-tooltip')
                Array.from(tooltip).forEach((item) => {
                    item.remove()
                })
            })
        },
        openDialog(position) {
            if (!this.mapDialogShow) this.mapDialogShow = true
            this.mapDialogleft = position.clientX + 10
            this.mapDialogTop = position.clientY + 10
        },
        initMapMain() {
            this.myChartMain = echarts.init(
                document.getElementById('main9-contianer'),
                null,
                {
                    renderer: 'svg',
                }
            )
            // 注册 echarts 地图
            echarts.registerMap('main9', main9)
            var markPointData = []
            let top = 0,
                left = 20,
                zoom = 1,
                map = 'main9',
                aspectScale = 1,
                layoutCenter = ['50%', '50%'],
                center = [106.204962, 29.533155] // 地图中心位置， 此处的纬度与下面的center相差1度是形成阴影的距离，可自己随意调整
            this.optionMain = {
                geo: [
                    {
                        map,
                        zoom,
                        zlevel: 0,
                        aspectScale,
                        itemStyle: {
                            normal: {
                                borderWidth: 0,
                            },
                        },
                        emphasis: {
                            disabled: true,
                        },
                        tooltip: {
                            show: false,
                        },
                        top,
                        left,
                        layoutCenter
                    },
                ],
                series: [
                    {
                        name: '重庆主城',
                        type: 'map',
                        map,
                        zoom, // 地图比例
                        zlevel: 100,
                        // center, // 地图中心位置， 此处的纬度与下面的center相差1度是形成阴影的距离，可自己随意调整
                        aspectScale,
                        itemStyle: {
                            normal: {
                                borderWidth: 1, //设置外层边框
                                borderColor: 'white',
                            },
                        },
                        emphasis: {
                            disabled: true,
                            itemStyle: {
                                areaColor: 'yellow',
                            },
                        },
                        top,
                        left,
                        data: this.convertData(
                            main9.features,
                            fakeData.btnkey1,
                            'risk',
                            true
                        ),
                    },
                    {
                        type: 'scatter',
                        symbol: (value, params) => {
                            return (
                                'image://' +
                                require(`@/assets/img/bigScreen/point1.png`)
                            )
                        },
                        coordinateSystem: 'geo',
                        symbolSize: [20, 20],
                        data: markPointData,
                        zlevel: 2000,
                        itemStyle: {
                            opacity: 1,
                        },
                    },
                ],
            }
            this.myChartMain.setOption(this.optionMain)
            this.myChartMain.on('click', (params) => {
                let code = params.value
                if (!code) {
                    code = this.getAreaCode(params.name, main9)
                }
                this.$router.push({
                    path: '/DistrictReformSubView',
                    query: {
                        name: params.name,
                        code: code,
                    },
                })
                let tooltip = document.querySelectorAll('.data-tooltip')
                Array.from(tooltip).forEach((item) => {
                    item.remove()
                })
            })
        },
        getAreaCode(name, dataType) {
            let code
            dataType.features.find(item => {
                if (item.properties.name == name) {
                    code = item.properties.code
                }
            })
            return code
        },
        resize(delay) {
            // 动态计算表格的高度，自适应当前容器
            setTimeout(() => {
                let dom = document.getElementById('cq-contianer')
                if (!dom) return
                let width = getComputedStyle(dom).getPropertyValue('width').replace('px', '')
                let height = getComputedStyle(dom).getPropertyValue('height').replace('px', '')
                width = parseInt(width, 10)
                height = parseInt(height, 10)
                this.myChartCQ.resize({
                    width: width,
                    height: width / 1.5
                })
                this.myChartMain.resize()
                this.deployTimeChart.resize()
                this.reformBrandChart.resize()
            }, delay || 0)
        },
    },
}